/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed * 0.1618 //dropped speed back substantially~ET
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// by maq/floppy
#define R 0.2      // to play
void main(void)
{
	vec3 col;
	vec2 uv = -0.5+gl_FragCoord.xy / iResolution.xy;
	uv.y*=0.66; // hack to get ar nice on 16:10
	vec2 p = uv;
	float d=sqrt(dot(p,p));
	float fac,fac2;
	if(d<R)
	{
		uv.x=p.x/(R+sqrt(R-d));
		uv.y=p.y/(R+sqrt(R-d));
		fac = 0.005;
		fac2 = 5.0;
	}
	else
	{
		uv.x=p.x/(d*d);
		uv.y=p.y/(d*d);
		fac = 0.02;
		fac2 = 25.0;
	}
	
	uv.x=uv.x-iMouse.x*fac+fac*500.0*sin(0.2*iGlobalTime);
	uv.y=uv.y-iMouse.y*fac+fac*500.0*sin(0.4*iGlobalTime);
	col = texture2D(iChannel0, uv/fac2).xyz;
	col = col*exp(-3.0*(d-R)); // some lighting
	col = col*(1.1-exp(-8.0*(abs(d-R)))); // and shading
	
	
	gl_FragColor = vec4(col,1.0);
	gl_FragColor.a = length(gl_FragColor.rgb);
}